
#define array_table
/*  ARRAY_TABLE
  GM Database Suppport v3.x by Alasdair Forsythe
  Puts table into/pulls table out of 2D array.
             argument0 is the path of the database file.
             argument1 is the table position.
             argument2 is the variable to use (as a string).
             argument3 is if to write it to the file (0=into array, 1=into file).
             
       The variable you put the table into with x and y on the end is the total x and y of the table
       eg. if argument2 is 'bob':
       bobx would contain the total columns, boby would contain the total rows
  -1 is returned if an error occurs
*/
var runthru,read,temp,tempb,pathz,encrypt,cols,rows,tabs,line,file
{
pathz=0; pathx=0; pathy=0;
if file_exists(argument0) fileoq=file_text_open_read(argument0) else return -1;//open database
if file_text_read_real(fileoq)>0 encrypt=1 else encrypt=0;//is it encrypted?
file_text_readln(fileoq);
if encrypt==1 tabs=real(encryption(file_text_read_string(fileoq),0)) else tabs=file_text_read_real(fileoq);//get total tables
file_text_readln(fileoq); line=2
//goto table>>
if is_real(argument1) {switch(argument1)
{
 case -1: cols=2; break;
 case -2: cols=3; break;
 default: pathz=argument1; cols=0; break;
}} else cols=1;
if encrypt==1 temp=encryption(file_text_read_string(fileoq),0) else temp=file_text_read_string(fileoq);
if cols>0
{
for (runthru=1; (runthru<=tabs && pathz==0); runthru+=1)
    {
    tempb=string_copy(temp,string_pos('{' + string(runthru) + '}',temp)+2+string_length(string(runthru)),string_pos('{' + string(runthru+1) + '}',temp)-string_pos('{' + string(runthru) + '}',temp)-(2+string_length(string(runthru))))
    switch (cols)
           {
           case 1: if tempb==argument1 pathz=runthru; break;
           case 2: tempqx=0; execute_string('if ' + tempb + ' tempqx=1'); if tempqx==1 pathz=runthru; break;
           case 3: execute_string('if ' + tempb + ' tempqx=0 else tempqx=1'); if tempqx==1 pathz=runthru; break;
           }
    }
}
// Put table title into array[0,0] >
if argument3==0
variable_local_array2_set(argument2,0,0,string_copy(temp,string_pos('{' + string(pathz) + '}',temp)+2+string_length(string(pathz)),string_pos('{' + string(pathz+1) + '}',temp)-string_pos('{' + string(pathz) + '}',temp)-(2+string_length(string(pathz)))))
file_text_readln(fileoq); line+=1;
for (runthru=1; runthru<=pathz; runthru+=1)// goto table
    {
    if encrypt==1 temp=encryption(file_text_read_string(fileoq),0) else temp=file_text_read_string(fileoq);
    cols=real(string_copy(temp,1,string_pos(',',temp)-1));// get total cols
    rows=real(string_delete(temp,1,string_pos(',',temp)));// get total rows
    file_text_readln(fileoq); line+=1;
    if rows>0 && cols>0 {if runthru!=pathz repeat(rows+2) {file_text_readln(fileoq); line+=1}}// goto next table
    }
if argument3==0//put into array
   {
   if encrypt temp=encryption(file_text_read_string(fileoq),0) else temp=file_text_read_string(fileoq);
   for (runthru=1; runthru<=cols; runthru+=1) // get column names
   variable_local_array2_set(argument2,runthru,0,string_copy(temp,string_pos('{' + string(runthru) + '}',temp)+2+string_length(string(runthru)),string_pos('{' + string(runthru+1) + '}',temp)-string_pos('{' + string(runthru) + '}',temp)-(2+string_length(string(runthru)))))   file_text_readln(fileoq);
   if encrypt temp=encryption(file_text_read_string(fileoq),0) else temp=file_text_read_string(fileoq);
   for (runthru=1; runthru<=rows; runthru+=1) // get y names
   variable_local_array2_set(argument2,0,runthru,string_copy(temp,string_pos('{' + string(runthru) + '}',temp)+2+string_length(string(runthru)),string_pos('{' + string(runthru+1) + '}',temp)-string_pos('{' + string(runthru) + '}',temp)-(2+string_length(string(runthru)))))
   file_text_readln(fileoq);
   for (runthru=1; runthru<=rows; runthru+=1) // get data
       {
       if encrypt temp=encryption(file_text_read_string(fileoq),0) else temp=file_text_read_string(fileoq);
       for (tempb=1; tempb<=cols; tempb+=1)       
       variable_local_array2_set(argument2,tempb,runthru,string_copy(temp,string_pos('{' + string(tempb) + '}',temp)+2+string_length(string(tempb)),string_pos('{' + string(tempb+1) + '}',temp)-string_pos('{' + string(tempb) + '}',temp)-(2+string_length(string(tempb)))))
       file_text_readln(fileoq);
       }
   variable_local_set(argument2+'x',cols)
   variable_local_set(argument2+'y',rows)  
   file_text_close(fileoq); exit;
   }
else//put back into database
   {
   line-=1; file_text_close(fileoq);
   //put whole file into array>
   fileoq=file_text_open_read(argument0)
   for (file=0; !file_text_eof(fileoq); {file+=1; file_text_readln(fileoq)})
   read[file]=file_text_read_string(fileoq)
   file_text_close(fileoq)
   
   filewq=file_text_open_write(argument0)
   file_text_write_string(filewq,read[0]); file_text_writeln(filewq);
   file_text_write_string(filewq,read[1]); file_text_writeln(filewq);
   
   //write new table name>
   tempb=variable_local_array2_get(argument2,0,0)
   if encrypt temp=encryption(read[2],0) else temp=read[2];
   temp=string_insert(tempb,string_delete(temp,string_pos('{' + string(pathz) + '}',temp)+2+string_length(string(pathz)),string_pos('{' + string(pathz+1) + '}',temp)-string_pos('{' + string(pathz) + '}',temp)-(2+string_length(string(pathz)))),string_pos('{' + string(pathz) + '}',temp)+2+string_length(string(pathz)))
   if encrypt file_text_write_string(filewq,encryption(temp,1)) else file_text_write_string(filewq,temp)
   file_text_writeln(filewq);
   
   //write first half of file>
   for (runthru=3; runthru<line; {runthru+=1; file_text_writeln(filewq)})
   file_text_write_string(filewq,read[runthru])
   
   if encrypt temp=encryption(read[runthru],0) else temp=read[runthru]
   if (real(string_copy(temp,1,string_pos(',',temp)-1))>0 && real(string_delete(temp,1,string_pos(',',temp)))>0) line+=2
   
   // write array table >
   tempqx=variable_local_get(argument2 + 'x');
   tempqy=variable_local_get(argument2 + 'y');
   if encrypt file_text_write_string(filewq,encryption(string(tempqx) + ',' + string(tempqy),1)) else file_text_write_string(filewq,string(tempqx) + ',' + string(tempqy))                      
   file_text_writeln(filewq);
   
 if tempqx>0 && tempqy>0
 {
   tempq='{1}'
   for (runthru=1; runthru<=tempqx; runthru+=1) // write x names
   {
   tempq+=variable_local_array2_get(argument2,runthru,0)
   tempq+='{' + string(runthru+1) + '}'
   }
   if encrypt file_text_write_string(filewq,encryption(tempq,1)) else file_text_write_string(filewq,tempq)
   file_text_writeln(filewq);
   
   tempq='{1}'
   for (runthru=1; runthru<=tempqy; runthru+=1) // write y names
   {
   tempq+=variable_local_array2_get(argument2,0,runthru)
   tempq+='{' + string(runthru+1) + '}'
   }
   if encrypt file_text_write_string(filewq,encryption(tempq,1)) else file_text_write_string(filewq,tempq)
   file_text_writeln(filewq);
   
   for (runthru=1; runthru<=tempqy; runthru+=1) // write data
   {
   tempq='{1}'
   for (temp=1; temp<=tempqx; temp+=1)
   {
   tempq+=variable_local_array2_get(argument2,temp,runthru)
   tempq+='{' + string(temp+1) + '}'
   }
   if encrypt file_text_write_string(filewq,encryption(tempq,1)) else file_text_write_string(filewq,tempq)
   file_text_writeln(filewq);
   }
 }
   line+=1+rows
   
   //write second half of file>
   for (runthru=line; runthru<file; {runthru+=1; if runthru<file file_text_writeln(filewq)})
   file_text_write_string(filewq,read[runthru])
   file_text_close(filewq)
   }
}

#define insert_array
/*  INSERT_ARRAY
  GM Database Suppport v3.x by Alasdair Forsythe
  Insert/delete column/row in 2D array.
             argument0 is the table array name.
             argument1 is the number along.
             argument2 is if column? (1=column, 0=row).
             argument3 is if insert? (1=insert, 0=delete).
*/
var runthru,temp,tempqx,tempqy
{
tempqx=variable_local_get(argument0 + 'x');
tempqy=variable_local_get(argument0 + 'y');
//if the number along to insert is too high reduce it>
if argument2==1 {if argument1>tempqx+argument3 || argument1==0 argument1=tempqx+argument3}
else {if argument1>tempqy+argument3 || argument1==0 argument1=tempqy+argument3}
if argument2==0//row
{
 if argument3==1//insert row
    {
    for (runthru=tempqy; runthru>=argument1; runthru-=1)//through y
    for (temp=0; temp<=tempqx; temp+=1)//through x
    variable_local_array2_set(argument0,temp,runthru+1,variable_local_array2_get(argument0,temp,runthru))
    variable_local_array2_set(argument0,0,argument1,"Row " + string(argument1))
    for (runthru=1; runthru<=tempqx; runthru+=1)//clear indexes of new row
    variable_local_array2_set(argument0,runthru,argument1,string(runthru) + ',' + string(argument1))
    variable_local_set(argument0 + 'y',variable_local_get(argument0 + 'y')+1)
    }
 else//delete row
    {
    for (runthru=argument1+1; runthru<=tempqy; runthru+=1)//through y
    for (temp=0; temp<=tempqx; temp+=1)//through x
    variable_local_array2_set(argument0,temp,runthru-1,variable_local_array2_get(argument0,temp,runthru))
    variable_local_set(argument0 + 'y',variable_local_get(argument0 + 'y')-1)
    }
 }
else//column
 {
 if argument3==1//insert column
    {
    for (runthru=tempqx; runthru>=argument1; runthru-=1)//through x
    for (temp=0; temp<=tempqy; temp+=1)//through y
    variable_local_array2_set(argument0,runthru+1,temp,variable_local_array2_get(argument0,runthru,temp))
    variable_local_array2_set(argument0,argument1,0,"Column " + string(argument1)) 
    for (runthru=1; runthru<=tempqy; runthru+=1)//clear indexs of new column
    variable_local_array2_set(argument0,argument1,runthru,string(argument1) + ',' + string(runthru))
    variable_local_set(argument0 + 'x',variable_local_get(argument0 + 'x')+1)
    }
 else//delete column
    {
    for (runthru=argument1+1; runthru<=tempqx; runthru+=1)//through x
    for (temp=0; temp<=tempqy; temp+=1)//through y
    variable_local_array2_set(argument0,runthru-1,temp,variable_local_array2_get(argument0,runthru,temp))
    variable_local_set(argument0 + 'x',variable_local_get(argument0 + 'x')-1)
    }
 }
}


#define array_search
/*  ARRAY_SEARCH
  GM Database Suppport v3.x by Alasdair Forsythe
  Search for cell in a 2D array.
             argument0 is the table array name.
             argument1 is the column.
             argument2 is the row.
             argument3 is the string to change it to (not required).
             
  NOTE: There's no point using this if you're just searching with numbers.
  Eg. if you want x2,y5 then it's just at array[2,5].
*/
var runthru,temp,pathx,tempqx,tempqy,tempq
{
tempqx=variable_local_get(argument0 + 'x');
tempqy=variable_local_get(argument0 + 'y');
if is_real(argument1) pathx=argument1 else pathx=-3
tempw=0;
for (runthru=1; runthru<=tempqx && pathx<0; runthru+=1)
{
tempq=variable_local_array2_get(argument0,runthru,0)
switch (pathx)
       {
       case -1: execute_string('if ' + tempq + ' tempw=1'); break;//true
       case -2: execute_string('if ' + tempq + ' tempw=0 else tempw=1'); break;//false
       case -3: if tempq==argument1 pathx=runthru; break;//name
       }
if tempw==1 pathx=runthru 
}
if is_real(argument2) pathy=argument2 else pathy=-3
tempw=0;
for (runthru=1; runthru<=tempqy && pathy<0; runthru+=1)
{
tempq=variable_local_array2_get(argument0,0,runthru)
switch (pathy)
       {
       case -1: execute_string('if ' + tempq + ' tempw=1'); break;//true
       case -2: execute_string('if ' + tempq + ' tempw=0 else tempw=1'); break;//false
       case -3: if tempq==argument1 pathy=runthru; break;//name
       }
if tempw==1 pathy=runthru 
}
if pathx<0 || pathy<0 return -1//if not found
if is_real(argument3)
return variable_local_array2_get(argument0,pathx,pathy)
else variable_local_array2_set(argument0,pathx,pathy,argument3)
}

